/*
 * XXXX 
 *
 * Fecha 14/05/2007
 * 
 *  
 */
 
package com.ejie.p06b.servlet.presentacion.DEC;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Calendar;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejie.p06b.datatype.logic.P06BPRDListasAux;
import com.ejie.p06b.datatype.logic.P06BError;
import com.ejie.p06b.datatype.model.P06B62T00Datatype;
import com.ejie.p06b.exception.P06BException;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BErrores;
import com.ejie.p06b.general.P06BPaginas;
import com.ejie.p06b.manager.P06BPRDsManager;
import com.ejie.p06b.p06bMediadoresSegurosEJB.P06BMediadoresSegurosEJB;
import com.ejie.p06b.p06bMediadoresSegurosEJB.P06BMediadoresSegurosEJBHome;

import com.ejie.p06b.servlet.P06BServletGenerico;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.P06BFieldsValidations;
import com.ejie.p06b.util.P06BParametros;
import com.ejie.p06b.util.P06BResources;
import com.ejie.p06b.xlnet.P06BPerfilUsuario;

/**
 *  Esta clase gestiona las peticiones HTTP de la aplicacin.
 */
public class P06BPRDModificarServlet extends P06BServletGenerico 
{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	//Cambia de idioma en la sesin -> Perfil
	public void ejecutar(HttpServletRequest request, HttpServletResponse response) {
		try {
			if(request.getParameter("accion")==null || request.getParameter("accion").equals("")){
				//Cuando damos al MODIFICAR (un corredor en la aplicacin) llego a este punto.
				//Por tanto debo resetear todas las variables de sesin de la aplicacin
				//para optimizar espacio. No borro los filtros.
				//Puede ser que haya navegado sin pasar por el men
				this.deleteTempFromSession(request,P06BConstantes.P06B_VAR_TEMP_FILTRO);
				//Vengo por primera vez al modificar (sin num. exp. seleccionado)
				//o si he quitado el valor al campo num. Exp. -> ""
			}else if (request.getParameter("accion").equals("cambio")){
				//Obtengo los valores de la BD y los meto en la request
				this.obtener(request,response);
			}else if (request.getParameter("accion").equals("tablaChange")){
				this.actualizarListas(request,response);
				this.anadirToListaPeriodos(request,response);
				
			}else if (request.getParameter("accion").equals("tablaDelete")){
				this.actualizarListas(request,response);
				this.eliminarFromListaPeriodos(request);
				
			}else{//en este else entrar si la accion es modificar
				this.actualizarListas(request,response);
				//Ha dado a Guardar -> accion = "guardar"
				//1. Valido los campos
				if(this.validate(request,response)){
					//2. Guardo el resultado en BD
					this.update(request,response);
					
					//3. Sino es que la accion es modificar, sacar Mensaje de Guardado correcto
					forward (request, response, P06BPaginas.P06B_JSP_PRD_MODIFICADO);
					return;
				}
			}
			//Redireccionamos a la pgina de Mto PRD - Modificaciones
			forward (request, response, P06BPaginas.P06B_JSP_PRD_MODIFICAR);
		}catch (Exception e){
	      	manejarErrores (request, response, e);
	        return;
	    }
	}
	
	//Recogemos las listas de la pantalla y se actualizan todas.
	private void actualizarListas (HttpServletRequest request, HttpServletResponse response) throws Exception {
		this.actualizarListaPeriodos(request,response);
	}
	
	//SOCIOS
	//Recogemos la lista de socios y las actualizamos con los nuevos valores
	private void actualizarListaPeriodos (HttpServletRequest request, HttpServletResponse response) throws Exception {
		String idioma = this.getIdioma(request,response);
		//Se ha dado a aadir un socio
		P06BPRDListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"PRDListasAux")!=null){
			objListas = (P06BPRDListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"PRDListasAux");
		}else{
			objListas = new P06BPRDListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B62T00Datatype obj = null;
		int numPRDs = objListas.getListaPeriodos().size();
		objListas.getListaPeriodos().clear();
		int z=0;
		for(z=0;z<numPRDs;z++){
			obj = new P06B62T00Datatype();
			String sEjercicioPRD = request.getParameter("ejercicio_periodo_"+z);
			int iEjercicioPRD = Integer.parseInt(sEjercicioPRD);
			obj.setEjercicio(iEjercicioPRD);
			Date fechaIni = null;
			String sFechaIniPRD = request.getParameter("fechaIni_periodo_"+z);
			if (P06BFecha.isFechaValida(sFechaIniPRD,idioma)==true){
				fechaIni = P06BFecha.dateDesdeString(sFechaIniPRD, idioma);
			}
			obj.setFechaIni(fechaIni);
			Date fechaFin = null;
			String sFechaFinPRD = request.getParameter("fechaFin_periodo_"+z);
			if (P06BFecha.isFechaValida(sFechaFinPRD,idioma)==true){
				fechaFin = P06BFecha.dateDesdeString(sFechaFinPRD, idioma);
			}
			obj.setFechaFin(fechaFin);
			objListas.getListaPeriodos().add(obj);
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"PRDListasAux",objListas);
	}
	
	//Recogemos la lista de socios y las actualizamos con los nuevos valores
	private void anadirToListaPeriodos (HttpServletRequest request, HttpServletResponse response) throws Exception {
		String idioma = this.getIdioma(request,response);
		//Se ha dado a aadir un socio
		P06BPRDListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"PRDListasAux")!=null){
			objListas = (P06BPRDListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"PRDListasAux");
		}else{
			objListas = new P06BPRDListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B62T00Datatype obj = null;
		int numPeriodos = objListas.getListaPeriodos().size();
		objListas.getListaPeriodos().clear();
		int z=0;
		for(z=0;z<numPeriodos;z++){
			obj = new P06B62T00Datatype();		
			String sEjercicioPRD = request.getParameter("ejercicio_periodo_"+z);
			int iEjercicioPRD = Integer.parseInt(sEjercicioPRD);
			obj.setEjercicio(iEjercicioPRD);
			String sFechaIniPRD = request.getParameter("fechaIni_periodo_"+z);
			Date fechaIni = P06BFecha.dateDesdeString(sFechaIniPRD, idioma);
			obj.setFechaIni(fechaIni);
			String sFechaFinPRD = request.getParameter("fechaFin_periodo_"+z);
			Date fechaFin = P06BFecha.dateDesdeString(sFechaFinPRD, idioma);
			obj.setFechaFin(fechaFin);
			objListas.getListaPeriodos().add(obj);
		}
		obj = new P06B62T00Datatype();
        Date fechaIni = new Date();
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
   		String ejercicio = simpleDateFormat.format(fechaIni);
		obj.setEjercicio(Integer.parseInt(ejercicio)-1);
		obj.setFechaIni(fechaIni);

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(fechaIni);
        calendar.add(Calendar.MONTH, 1);
        Date fechaFin = calendar.getTime();

		obj.setFechaFin(fechaFin);
		objListas.getListaPeriodos().add(obj);
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"PRDListasAux",objListas);
	}
	
	//Recogemos la lista de socios y eliminamos el valor seleccionado
	private void eliminarFromListaPeriodos (HttpServletRequest request) throws Exception {
		String idTablaDelete = (request.getParameter("idTablaDelete")==null)?"":request.getParameter("idTablaDelete");
		int iIdTablaDelete = Integer.parseInt(idTablaDelete);
		P06BPRDListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"PRDListasAux")!=null){
			objListas = (P06BPRDListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"PRDListasAux");
		}else{
			objListas = new P06BPRDListasAux();
		}
		//Recorro la lista de socios y elimino aquel cuyo identificador 
		//coincida con idTablaDelete
		for(int i=0;i<objListas.getListaPeriodos().size();i++){
			P06B62T00Datatype obj = (P06B62T00Datatype)objListas.getListaPeriodos().get(i);
			if(obj.getEjercicio()==iIdTablaDelete){
				objListas.getListaPeriodos().remove(i);
				break;
			}
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"PRDListasAux",objListas);
	}
	
	//Obtengo el PRD de la B.D. y lo meto en la request
	private void obtener(HttpServletRequest request, HttpServletResponse response) throws Exception {
		P06BPRDListasAux objListas = new P06BPRDListasAux();
		//---------- LAS LISTAS SE OBTIENEN  ----------
		
		//Ahora recupero los periodos directos relacionados con el corredor
		objListas.setListaPeriodos(P06BPRDsManager.getInstance().selectPRDs());
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"PRDListasAux",objListas);
	}
	
	
	//Validamos campos del formulario
	private boolean validate(HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		P06BPerfilUsuario lPerfil = this.getP06BPerfilUsuario(request,response);
		
		//INICIO PANTALLA PRINCIPAL
		ArrayList errors = new ArrayList();
		boolean resultado = true;
		
		
		String idioma = this.getIdioma(request,response);
		//Con la informacin obtenida realizo las validaciones
		P06BResources res = (P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS); 
		
		P06BPRDListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"PRDListasAux")!=null){
			objListas = (P06BPRDListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"PRDListasAux");
		}else{
			objListas = new P06BPRDListasAux();
		}
		//FIN PANTALLA PRINCIPAL
		
		
		//PESTAA 2 - PRDS
		int numPRDs = objListas.getListaPeriodos().size();		
		int z=0,numErrors = 0;;
		P06B62T00Datatype periodo = null;
		boolean valida1 = true, valida2 = true;
		
//		for(z=0;z<numPRDs;z++){
//			periodo = (P06B62T00Datatype)objListas.getListaPeriodos().get(z);
//			String sFechaIniPRD = request.getParameter("fechaIni_periodo_"+z);
//			String sFechaFinPRD = request.getParameter("fechaFin_periodo_"+z);
//			numErrors = errors.size();
//			if(valida1){
//				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.OBLIGATORIO,res.get("pantallas.literal.periodos.textoPestana") + " - " + res.get("pantallas.literal.periodos.fechaIni"),sFechaIniPRD,idioma);
//				if(numErrors<errors.size()){
//					valida1=false;					
//				}else{
//					errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.periodos.textoPestana") + " - " + res.get("pantallas.literal.periodos.fechaIni"),sFechaIniPRD,idioma);
//					if(numErrors<errors.size()){
//						valida1=false;					
//					}
//				}
//			}
//			numErrors = errors.size();
//			if(valida2){
//				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.OBLIGATORIO,res.get("pantallas.literal.periodos.textoPestana") + " - " + res.get("pantallas.literal.periodos.fechaFin"),sFechaFinPRD,idioma);
//				if(numErrors<errors.size()){
//					valida2=false;					
//				}else{
//					errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.periodos.textoPestana") + " - " + res.get("pantallas.literal.periodos.fechaFin"),sFechaFinPRD,idioma);
//					if(numErrors<errors.size()){
//						valida2=false;					
//					}
//				}
//			}
//		}
//		
//		//Valida que si se ha introducido algun dato en alguna fila, se obligue a introducir los oblidatorios.
//		z = 0;
//		periodo = null;
//		valida1 = true;
//		while (valida1 && z<numPRDs){
//			periodo = (P06B62T00Datatype)objListas.getListaPeriodos().get(z);
//			if (
//				(periodo.getEjercicio()==0 || periodo.getFechaIni()==null || periodo.getFechaFin()==null) 
//				&& (
//                    (periodo.getEjercicio()!=0)
//					|| (periodo.getFechaIni()!=null)
//					|| (periodo.getFechaFin()!=null)
//					)
//				){
//				errors=this.insertaError(errors, res.get("pantallas.literal.periodos.textoPestana") + " - " + res.get("pantallas.literal.periodos.ejercicio"),P06BErrores.P06B_ERROR_0024);
//				valida1=false;
//			}
//			z++;
//		}
//		
//		//Valida que el campo Identificador no est repetido
//		z = 0;
//		periodo = null;
//		valida1 = true;
//		int i = 0;
//		P06B62T00Datatype periodo2 = null;
//		while (valida1 && z<numPRDs){
//			i = 0;
//			periodo = (P06B62T00Datatype)objListas.getListaPeriodos().get(z);
//			while (valida1 && i<numPRDs){
//				if (i!=z){
//					periodo2 = (P06B62T00Datatype)objListas.getListaPeriodos().get(i);
//					if (periodo.getEjercicio()==periodo2.getEjercicio()){
//						errors=this.insertaError(errors, res.get("pantallas.literal.periodos.textoPestana") + " - " + res.get("pantallas.literal.periodos.ejercicio"),P06BErrores.P06B_ERROR_0025);
//						valida1=false;
//					}
//				}				
//				i++;
//			}
//			z++;
//		}
		for(z=0;z<numPRDs;z++){
			periodo = (P06B62T00Datatype)objListas.getListaPeriodos().get(z);
			if ((periodo.getEjercicio()!=0)
					|| (periodo.getFechaIni()!=null)
					|| (periodo.getFechaFin()!=null)
					){
				valida1 = true;
				if (periodo.getEjercicio()==0){
					errors=this.insertaError(errors, res.get("pantallas.literal.periodos.textoPestana") + " - " + res.get("pantallas.literal.periodos.ejercicio"),P06BErrores.P06B_ERROR_0024);
					valida1=false;
				}
				if (valida1){
					//Valida que el campo Identificador no est repetido
					int i = 0;
					while (i<numPRDs){
						if (i!=z){
							P06B62T00Datatype periodo2 = (P06B62T00Datatype)objListas.getListaPeriodos().get(i);
							if (periodo.getEjercicio()==periodo2.getEjercicio()){
								errors=this.insertaError(errors, res.get("pantallas.literal.periodos.textoPestana") + " - " + periodo.getEjercicio() + " - " + res.get("pantallas.literal.periodos.ejercicio"),P06BErrores.P06B_ERROR_0025);
								valida1=false;
								break;
							}
						}				
						i++;
					}
				}
				String sFechaIniPRD = request.getParameter("fechaIni_periodo_"+z);
				String sFechaFinPRD = request.getParameter("fechaFin_periodo_"+z);
				if(valida1){
					numErrors = errors.size();
					errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.OBLIGATORIO,res.get("pantallas.literal.periodos.textoPestana") + " - " + periodo.getEjercicio() + " - " + res.get("pantallas.literal.periodos.fechaIni"),sFechaIniPRD,idioma);
					if(numErrors<errors.size()){
						valida1=false;					
					}else{
						numErrors = errors.size();
						errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.periodos.textoPestana") + " - " + periodo.getEjercicio() + " - " + res.get("pantallas.literal.periodos.fechaIni"),sFechaIniPRD,idioma);
						if(numErrors<errors.size()){
							valida1=false;					
						}
					}
				}
				if(valida1){
					numErrors = errors.size();
					errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.OBLIGATORIO,res.get("pantallas.literal.periodos.textoPestana") + " - " + periodo.getEjercicio() + " - " + res.get("pantallas.literal.periodos.fechaFin"),sFechaFinPRD,idioma);
					if(numErrors<errors.size()){
						valida1=false;					
					}else{
						numErrors = errors.size();
						errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.periodos.textoPestana") + " - " + periodo.getEjercicio() + " - " + res.get("pantallas.literal.periodos.fechaFin"),sFechaFinPRD,idioma);
						if(numErrors<errors.size()){
							valida1=false;					
						}else{
							if (periodo.getFechaIni().compareTo(periodo.getFechaFin())>0){
								errors=this.insertaError(errors, res.get("pantallas.literal.periodos.textoPestana") + " - " + periodo.getEjercicio(),P06BErrores.P06B_ERROR_0026);
								valida1=false;								
							}
						}
					}
				}
			}
		}
		//FIN PESTAA 2 - PRDS
		
		//Comprobamos que haya algn error
		if(!errors.isEmpty())
			resultado = false;
		request.setAttribute("errors",errors);
		return resultado;
	}
	
	//Modificamos los periodos en la BD 
	private void update(HttpServletRequest request, HttpServletResponse response) throws P06BException{
		try{
			
			P06BPRDListasAux listas = new P06BPRDListasAux();
			if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"PRDListasAux")!=null){
				listas = (P06BPRDListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"PRDListasAux");
			}
			
			//Pongo las fechas de los objetos de las listas OK
			//Pongo los campos numricos con el formato correcto
			//Verifico que aquellos socios donde todos los campos sean vacos, no se guarden
			
			//PRDS
			P06B62T00Datatype periodo = null;
			int indice = 0;
			int sizeLista = listas.getListaPeriodos().size();
			for(int i=0;i<sizeLista;i++){
				periodo = (P06B62T00Datatype)listas.getListaPeriodos().get(indice);		
				if(periodo.getEjercicio()==0 || periodo.getFechaIni()==null || periodo.getFechaFin()==null){
					listas.getListaPeriodos().remove(indice);
				}
			}
			//Fin PRDS
			
			Context context =new InitialContext();
			Object objRef = context.lookup(P06BParametros.get("mediadoresSeguros.ejb.jndiName"));
			P06BMediadoresSegurosEJBHome home = (P06BMediadoresSegurosEJBHome)javax.rmi.PortableRemoteObject.narrow(
	                		  objRef, P06BMediadoresSegurosEJBHome.class);
			P06BMediadoresSegurosEJB mediadoresSeguroEJB = home.create();
			mediadoresSeguroEJB.updatePeriodos(listas);
		}
//		catch (P06BException e){
//	      	throw e;
//	    }
		catch (Exception e){
	    	throw new P06BException(new Exception("Error Actualizacin BD"),P06BErrores.P06B_ERROR_0009);
	    }
	}
	
	
	private ArrayList insertaError(ArrayList errors, String nombreCampo, String codigo) {
	 	P06BError error = new P06BError();
		error.setNombreCampo(nombreCampo);
		error.setCodigo(codigo);
		errors.add(error);
		return errors;
   	}
	
}